﻿Discussion = {
    openIconColors: {
        open: "#e69700",
        close: "#2293f7"
    },

    openIcon: function (_selector) {
        var _jquerySelector = $(_selector);

        if (_jquerySelector.attr("data-attribute-count") > 0) {
            if (!_jquerySelector.hasClass("fas")) {
                _jquerySelector.removeClass("fa-discourse").removeClass("fab").addClass("fas");
                _jquerySelector.closest(".discussionDisc-container").css("cursor", "pointer");
            }

            if (_jquerySelector.closest(".discussion-container").find(".discussionPost-container").length === 0) {
                _jquerySelector.css("color", Discussion.openIconColors.close);
                _jquerySelector.attr("data-attribute-status", "close");

                _jquerySelector.removeClass("fa-minus").addClass("fa-plus");
            } else {
                _jquerySelector.css("color", Discussion.openIconColors.open);
                _jquerySelector.attr("data-attribute-status", "open");

                _jquerySelector.addClass("fa-minus").removeClass("fa-plus");
            }
        }
    },

    contextMenuKeys: function (key, options, type) {
        $("#Discussion-Comment").val("");

        if (key === "delete") {
            $("#discussion-delete-dialog-confirm-approve").attr("data-attribute-discussionGuid", options.$trigger.attr("data-attribute-id"));

            $("#discussion-delete-dialog-confirm").dialog({
                resizable: false,
                width: 400,
                modal: true,
                position: {
                    my: "center top",
                    at: "center top+20%",
                    of: window
                }
            });
        }

        else if (key === "addDisc") {
            $("#discussion-add-dialog-confirm").attr("data-attribute-elementGuid", $("#discussion-full-container").attr("data-attribute-elementGuid"));
            $("#discussion-add-dialog-confirm").attr("data-action", "DiscussionCreate");

            $("#discussion-add-dialog").dialog({
                resizable: false,
                width: 400,
                modal: true,
                position: {
                    my: "center top",
                    at: "center top+20%",
                    of: window
                }
            });
        }

        else if (key === "addPost") {
            $("#discussion-add-dialog-confirm").attr("data-attribute-discussionGuid", options.$trigger.closest(".discussion-container").find(".discussionDisc-container").attr("data-attribute-id"));
            $("#discussion-add-dialog-confirm").attr("data-action", "DiscussionPostCreate");

            $("#discussion-add-dialog").dialog({
                resizable: false,
                width: 400,
                modal: true,
                position: {
                    my: "center top",
                    at: "center top+20%",
                    of: window
                }
            });
        }

        else if (key === "editDisc") {
            $("#discussion-edit-dialog-confirm").attr("data-attribute-discussionGuid", options.$trigger.attr("data-attribute-id"));
            $("#discussion-edit-dialog-confirm").attr("data-attribute-discussionType", "EDisc");

            $("#Discussion-Context").val($(".discussionDisc-context[data-attribute-id=\"" + options.$trigger.attr("data-attribute-id") + "\"]").html().trim());

            $("#discussion-edit-status").css("display", "block");
            var status = $("input[name=\"discussion-status\"]");
            status[0].checked = false;
            status[1].checked = false;
            status[2].checked = false;
            status.checkboxradio("refresh");

            status = $("input[name=\"discussion-status\"][data-value=\"" + $(".discussion-container[data-attribute-id=\"" + options.$trigger.attr("data-attribute-id") + "\"]").attr("data-attribute-status") + "\"]");
            status[0].checked = true;
            status.checkboxradio("refresh");

            $("#discussion-edit-priority").css("display", "block");
            var priority = $("input[name=\"discussion-priority\"]");
            priority[0].checked = false;
            priority[1].checked = false;
            priority[2].checked = false;
            priority[3].checked = false;
            priority.checkboxradio("refresh");

            priority = $("input[name=\"discussion-priority\"][data-value=\"" + $(".discussion-container[data-attribute-id=\"" + options.$trigger.attr("data-attribute-id") + "\"]").attr("data-attribute-priority") + "\"]");
            priority[0].checked = true;
            priority.checkboxradio("refresh");

            $("#discussion-edit-dialog").dialog({
                resizable: false,
                width: 400,
                modal: true,
                position: {
                    my: "center top",
                    at: "center top+20%",
                    of: window
                },
                close: function (event, ui) {
                    $("#discussion-edit-dialog").dialog('destroy');
                }
            });
        }

        else if (key === "editPost") {
            $("#discussion-edit-dialog-confirm").attr("data-attribute-discussionGuid", options.$trigger.attr("data-attribute-id"));
            $("#discussion-edit-dialog-confirm").attr("data-attribute-discussionType", "EPost");

            $("#Discussion-Context").val($(".discussionPost-context[data-attribute-id=\"" + options.$trigger.attr("data-attribute-id") + "\"]").html().trim());

            $("#discussion-edit-status").css("display", "none");
            $("#discussion-edit-priority").css("display", "none");

            $("#discussion-edit-dialog").dialog({
                resizable: false,
                width: 400,
                modal: true,
                position: {
                    my: "center top",
                    at: "center top+20%",
                    of: window
                },
                close: function (event, ui) {
                    $("#discussion-edit-dialog").dialog('destroy');
                }
            });
        }
    },

    hideClosed: function () {
        var _closedDiscussion = $("#discussion-showClosedTopics").is(":checked");

        $(".discussion-container").each(function () {
            if (_closedDiscussion) {
                $(this).removeClass("display-none");
            } else {
                if ($(this).attr("data-attribute-closed") === "1") {
                    $(this).addClass("display-none");
                }
            }
        });
    }
};

$(document).ready(function () {
    $(document).on("click", "#discussion-add-disc-button", function () {
        Discussion.contextMenuKeys("addDisc");
    });

    $(document).on("click", "#discussion-showClosedTopics", function () {
        Discussion.hideClosed();
    });

    $(document).on("click", "#discussion-edit-dialog-confirm", function () {
        var _jqueryDialog = $(this);

        var _discussionGuid = _jqueryDialog.attr("data-attribute-discussionguid");
        var _discussionType = _jqueryDialog.attr("data-attribute-discussiontype");
        var _priority = $("[name=\"discussion-priority\"]:checked").val();
        var _status = $("[name=\"discussion-status\"]:checked").val();
        var _context = $("#Discussion-Context").val();

        var data = {
            discussionGuid: _discussionGuid,
            discussionType: _discussionType,
            priority: _priority,
            status: _status,
            context: _context
        };

        var callBack = function () {
            if (_discussionType === "EDisc") {
                var _thisRootDisc = $("#discussion-full-container");
                var _jqueryRootDisc = $(_thisRootDisc);

                var informationRoot = {
                    _this: _jqueryRootDisc,
                    selector: _jqueryRootDisc,
                    loading: _jqueryRootDisc,
                    line: true
                };

                var dataRoot = {
                    discussionGuid: _discussionGuid
                };

                var callBackRoot = {
                    before: function (returnData) {
                        $("div.discussion-container[data-attribute-id=\"" + _discussionGuid + "\"]").replaceWith(returnData);

                        Discussion.hideClosed();

                        Discussion.openIcon(_jqueryRootDisc.find(".discussionDisc-container[data-attribute-id=\"" + _discussionGuid + "\"]").find(".discussion-open"));
                    },
                    after: function () { },
                    stopLoading: true
                };
                debugger;
                Ajax.Loading(informationRoot, dataRoot, callBackRoot);
            } else {
                $(".discussionPost-context[data-attribute-id=\"" + _discussionGuid + "\"]").html(_context);
            }
        };

        Dialog.Saving(_jqueryDialog, data, callBack);
    });

    $(document).on("click", "#discussion-delete-dialog-confirm-approve", function () {
        var _jqueryDialog = $(this);

        var data = {
            discussionGuid: _jqueryDialog.attr("data-attribute-discussionguid")
        };

        var callBack = function () {
            if ($(".discussion-container[data-attribute-id=\"" + _jqueryDialog.attr("data-attribute-discussionguid") + "\"]").length > 0) {
                $(".discussion-container[data-attribute-id=\"" + _jqueryDialog.attr("data-attribute-discussionguid") + "\"]").remove();

                if ($(".ui-dialog-content").dialog("instance") !== undefined) {
                    $(".ui-dialog-content").dialog("close");
                }
            } else {
                var _thisDisc = $(".discussionPost-container[data-attribute-id=\"" + _jqueryDialog.attr("data-attribute-discussionguid") + "\"]").closest("div.discussion-container").find("div.discussionDisc-container");
                var _jqueryDisc = $(_thisDisc);

                var information = {
                    _this: _jqueryDisc,
                    selector: _jqueryDisc,
                    loading: _jqueryDisc,
                    line: true
                };

                var data = {
                    discussionGuid: _jqueryDisc.attr("data-attribute-id")
                };

                var callBack = {
                    before: function () {
                        $("div.discussionPost-container[data-attribute-id=\"" + _jqueryDialog.attr("data-attribute-discussionguid") + "\"]").remove();

                        Discussion.openIcon(_jqueryDisc.find(".discussion-open"));
                    },
                    after: function () {
                        if ($(".ui-dialog-content").dialog("instance") !== undefined) {
                            $(".ui-dialog-content").dialog("close");
                        }
                    }
                };

                Ajax.Loading(information, data, callBack);
            }
        };

        Dialog.Saving(_jqueryDialog, data, callBack);
    });

    $(document).on("click", "#discussion-add-dialog-confirm", function () {
        var _jqueryDialog = $(this);

        var _comment = $(_jqueryDialog).closest(".ui-dialog").find("#Discussion-Comment").val();

        var data = {
            discussionGuid: _jqueryDialog.attr("data-attribute-discussionGuid"),
            elementGuid: _jqueryDialog.attr("data-attribute-elementGuid"),
            context: _comment
        };

        var callBack = function (itemGuid) {
            if (_jqueryDialog.attr("data-action") === "DiscussionPostCreate") {
                var _thisDisc = $(".discussionDisc-container[data-attribute-id=\"" + _jqueryDialog.attr("data-attribute-discussionguid") + "\"]");
                var _jqueryDisc = $(_thisDisc);

                var information = {
                    _this: _jqueryDisc,
                    selector: _jqueryDisc,
                    loading: _jqueryDisc,
                    line: true
                };

                var data = {
                    discussionGuid: _jqueryDisc.attr("data-attribute-id")
                };

                var callBack = {
                    before: function () {
                        var _thisDiscPost = $(".discussion-open-sub[data-attribute-id=\"" + _jqueryDialog.attr("data-attribute-discussionguid") + "\"]");
                        var _jqueryDiscPost = $(_thisDiscPost);

                        var information = {
                            _this: _jqueryDiscPost,
                            selector: _jqueryDiscPost,
                            loading: _jqueryDisc,
                            line: true
                        };

                        var data = {
                            discussionGuid: _jqueryDiscPost.attr("data-attribute-id")
                        };

                        var callBack = {
                            before: function () {
                                Discussion.openIcon(_jqueryDisc.find(".discussion-open"));
                            },
                            after: function () {
                                $(_jqueryDialog).closest(".ui-dialog").find("#Discussion-Comment").val("");

                                if ($(".ui-dialog-content").dialog("instance") !== undefined) {
                                    $(".ui-dialog-content").dialog("close");
                                }
                            }
                        };

                        Ajax.Loading(information, data, callBack);
                    },
                    after: function () { }
                };

                Ajax.Loading(information, data, callBack);
            } else {
                var _thisRootDisc = $("#discussion-full-container");
                var _jqueryRootDisc = $(_thisRootDisc);

                var informationRoot = {
                    _this: _jqueryRootDisc,
                    selector: _jqueryRootDisc,
                    loading: _jqueryRootDisc,
                    line: true
                };

                var dataRoot = {
                    discussionGuid: itemGuid
                };

                var callBackRoot = {
                    before: function (returnData) {
                        _jqueryRootDisc.append(returnData);

                        Discussion.openIcon(_jqueryRootDisc.find(".discussionDisc-container[data-attribute-id=\"" + itemGuid + "\"]").find(".discussion-open"));
                    },
                    after: function () { },
                    stopLoading: true
                };

                Ajax.Loading(informationRoot, dataRoot, callBackRoot);
            }
        };

        Dialog.Saving(_jqueryDialog, data, callBack);
    });

    $(document).on("click", ".discussionDisc-container", function () {
        var _thisLocal = $(this).find(".discussion-open");
        var _jqueryLocal = $(_thisLocal);

        if (_jqueryLocal.attr("data-attribute-count") > 0) {
            if (_jqueryLocal.closest(".discussion-container").find(".discussionPost-container").length !== 0) {

                $(".discussion-open-sub[data-attribute-id=\"" + $(_jqueryLocal).attr("data-attribute-id") + "\"]").html("");

                Discussion.openIcon(_jqueryLocal);
            } else {
                var _thisSubLocal = $(".discussion-open-sub[data-attribute-id=\"" + _jqueryLocal.attr("data-attribute-id") + "\"]");
                var _jquerySubLocal = $(_thisSubLocal);

                var information = {
                    _this: _jquerySubLocal,
                    selector: _jquerySubLocal,
                    loading: _jquerySubLocal.closest(".discussion-container"),
                    line: true
                };

                var data = {
                    discussionGuid: _jquerySubLocal.attr("data-attribute-id")
                };

                var callBack = {
                    before: function () { },
                    after: function () {
                        Discussion.openIcon(_jqueryLocal);
                    }
                };

                Ajax.Loading(information, data, callBack);
            }
        }
    });
});