﻿/* Event */
$(document).ready(function () {

    /* History */
    History.Adapter.bind(window, "statechange", function () {
        if (History.getState().url !== undefined) {
            if (History.getState().url.indexOf("guid") !== -1) {
                Repository.TreeDetail(History.getState());
            } else {
                $("#repository-detail").text("");
            }
        } else {
            $("#repository-detail").text("");
        }
    });

    /* Hide & Unhide */
    $("#repository-hide-unhide").click(function () {
        if (!$(this).hasClass("fa-angle-double-left")) {
            $("#repository-tree-container").show();
            $("#repository-hide-unhide").addClass("fa-angle-double-left").removeClass("fa-angle-double-right");

            $("#repository-detail-container").css("width", $("#repository-detail-container").prop("data-width"));

            $.cookie("Variable.Repository.Tree.Visible", true);
        } else {
            $("#repository-tree-container").hide("Fade");
            $("#repository-hide-unhide").addClass("fa-angle-double-right").removeClass("fa-angle-double-left");

            $("#repository-detail-container").prop("data-width", $("#repository-detail-container").css("width"));
            $("#repository-detail-container").css("width", "100%");

            $.cookie("Variable.Repository.Tree.Visible", false);
        }
    });

    $("#enable-repository-enable").click(function () {
        if (!$(this).hasClass("fa-map-marker-edit")) {
            $(this).addClass("fa-map-marker-edit").removeClass("fa-map-marker-times");

            $.cookie("Variable.Repository.Tree.Editable", false);
        } else {
            $(this).addClass("fa-map-marker-times").removeClass("fa-map-marker-edit");

            $.cookie("Variable.Repository.Tree.Editable", true);
        }
    });

    $(document).on("click", "#detail-hide-unhide", function (event) {
        if (!$(this).hasClass("fa-eye-slash")) {
            $("#tabs").show("Fade");
            $("#repository-detail-attribute").show("Fade");
            $(this).addClass("fa-eye-slash").removeClass("fa-eye");

            $("#DownloadImageWith").show("Fade");
            $("#DownloadImageWithout").hide("Fade");
        } else {
            $("#tabs").hide("Fade");
            $("#repository-detail-attribute").hide("Fade");
            $(this).addClass("fa-eye").removeClass("fa-eye-slash");

            $("#DownloadImageWith").hide("Fade");
            $("#DownloadImageWithout").show("Fade");
        }
    });

    /* Draggable */
    $(document).bind("mousewheel DOMMouseScroll", function (event) {
        if (event.ctrlKey === true) {
            if ($(this).hasClass("draggable") || $(this).find(".draggable").length > 0) {
                event.preventDefault();
                event.stopPropagation();

                if (event.type === "mousewheel") {
                    scrollTo = event.originalEvent.wheelDelta;
                } else if (event.type === "DOMMouseScroll") {
                    scrollTo = event.originalEvent.detail;
                }

                if (scrollTo > 0) {
                    Repository.ChangeSize(0.1);
                } else {
                    Repository.ChangeSize(-0.1);
                }
            }
        }
    });
});

/* Repository */
Repository = {

    /* TreeDetail */
    TreeDetail: function (data) {
        var selector = $("#repository-detail");

        var information = {
            _this: $(selector),
            selector: $(selector),
            loading: $(selector)
        };

        var callBack = {
            before: function () { },
            after: function () { }
        };

        var params = data.data;

        if (params.guid === undefined) {
            params.guid = Repository.getParameterByName("guid", data.hashedUrl);
        }

        if (data.hashedUrl !== undefined)
            data.hashedUrl = data.hashedUrl.replace("%7B", "{").replace("%7D", "}");

        Ajax.Loading(information, params, callBack);
    },

    getParameterByName: function (name, url) {
        if (!url) url = window.location.href;
        name = name.replace(/[\[\]]/g, '\\$&');
        var regex = new RegExp('[?&]' + name + '(=([^&#]*)|&|#|$)'),
            results = regex.exec(url);
        if (!results) return null;
        if (!results[2]) return '';
        return decodeURIComponent(results[2].replace(/\+/g, ' '));
    },

    /* Change Size */
    ChangeSize: function (direction) {
        var model = parseFloat($("#repository-diagram-image").attr("data-zoom"));

        if (direction >= 0 && model < 4 || -0.7 < model && direction <= 0) {
            if (direction === 0) {
                $("#repository-diagram-image").attr("data-zoom", 0);
            } else {
                $("#repository-diagram-image").attr("data-zoom", model + direction);
            }

            model = $("#repository-diagram-image").attr("data-zoom");

            var width = $("#repository-diagram-image").attr("data-width") / Variable.Repository.Diagram.Scale.Width;
            var height = $("#repository-diagram-image").attr("data-height") / Variable.Repository.Diagram.Scale.Height;

            $("#repository-diagram").width(width + width * model);
            $("#repository-diagram-image").width(width + width * model);
            $("#repository-diagram-image").height(height + height * model);

            $(".imageMap").each(function (i) {
                $(this).css("left", parseFloat($(this).attr("data-left")) / Variable.Repository.Diagram.Scale.Width + parseFloat($(this).attr("data-left")) / Variable.Repository.Diagram.Scale.Width * model);
                $(this).css("top", parseFloat($(this).attr("data-top")) / Variable.Repository.Diagram.Scale.Height + parseFloat($(this).attr("data-top")) / Variable.Repository.Diagram.Scale.Height * model);

                $(this).css("width", parseFloat($(this).attr("data-width")) / Variable.Repository.Diagram.Scale.Width + parseFloat($(this).attr("data-width")) / Variable.Repository.Diagram.Scale.Width * model);
                $(this).css("height", parseFloat($(this).attr("data-height")) / Variable.Repository.Diagram.Scale.Height + parseFloat($(this).attr("data-height")) / Variable.Repository.Diagram.Scale.Height * model);
            });
        }
    }
};