var DataprojektBootstrap = {
    // Variables
    RepositoryTreeForSelectObject: null,

    // Enums
    NotificationType: {
        Success: 1,
        Warning: 2,
        Info: 3,
        Danger: 4
    },

    // Flags
    RepositoryBrowserForSelectType: {
        All: 31,
        Packages: 1,
        Elements: 2,
        Diagrams: 4,
        Attributes: 8,
        Operations: 16
    },

    // Functions
    Notification: function (_notificationType, _notificationContent, _notificationFadeSeconds = 10) {
        var notificationClass = "";
        var notificationIcon = "";

        switch (_notificationType) {
            case DataprojektBootstrap.NotificationType.Success:
                notificationClass = "alert-success";
                notificationIcon = "far fa-shield-check";
                break;

            case DataprojektBootstrap.NotificationType.Info:
                notificationClass = "alert-info";
                notificationIcon = "far fa-comment-alt-exclamation";
                break;

            case DataprojektBootstrap.NotificationType.Warning:
                notificationClass = "alert-warning";
                notificationIcon = "far fa-exclamation-triangle";
                break;

            case DataprojektBootstrap.NotificationType.Danger:
                notificationClass = "alert-danger";
                notificationIcon = "far fa-exclamation-triangle";
                break;
        }

        $("#NotificationToaster").remove();

        var notificationDiv =
            $("<div></div>").attr("id", "NotificationToaster").append(
                $("<div></div>").addClass(notificationClass).append(
                    $("<div></div>").append(
                        $("<i></i>").addClass(notificationIcon),
                        $("<span></span>").html(_notificationContent)
                    )
                )
            );

        $("body").append(notificationDiv);

        $(notificationDiv).click(function () {
            $(notificationDiv).fadeOut("slow");
        });

        setTimeout(function () {
            $(notificationDiv).fadeOut("slow");
        }, _notificationFadeSeconds * 1000);
    },

    RepositoryBrowserForSelect: function (_repositoryBrowserForSelectType, _repositoryBrowserForSelectCallBack, _returnBack) {
        $("#RepositoryBrowserForSelect").remove();
        if (_returnBack === undefined) {
            _returnBack = false;
        }
        var repositoryBrowserForSelectDiv =
            $("<div></div>").attr("id", "RepositoryBrowserForSelect").addClass("modal fade bd-example-modal-xl").append(
                $("<div></div>").addClass("modal-dialog modal-xl modal-dialog-scrollable").append(
                    $("<div></div>").addClass("modal-content").append(
                        $("<div></div>").addClass("modal-header").append(
                            $("<h5></h5>").attr("type", "button").addClass("modal-title").html(
                                DataprojektLocalizer.Tree["Repository browser"]
                            ),
                            $("<button></button>").attr("type", "button").addClass("close").attr("data-dismiss", "modal").html(
                                $("<span></span>").html(
                                    "&times;"
                                )
                            )
                        ),
                        $("<div></div>").addClass("modal-body").append(
                        ),
                        $("<div></div>").addClass("modal-footer").append(
                            $("<button></button>").attr("type", "button").addClass("btn btn-secondary").attr("data-dismiss", "modal").attr(_returnBack ? "onclick" : "temp", "history.back();").html(
                                DataprojektLocalizer.Shared["Close"]
                            ),
                            $("<button></button>").attr("id", "RepositoryBrowserForSelectSelected").attr("type", "button").attr("data-dismiss", "modal").addClass("btn btn-primary").html(
                                DataprojektLocalizer.Tree["Select artefact"]
                            )
                        )
                    )
                )
            );

        $("body").append(repositoryBrowserForSelectDiv);

        $.ajax({
            url: "/Tree/Index",
            data: {
                selectType: _repositoryBrowserForSelectType
            }
        }).done(function (data, textStatus, jqXHR) {
            if (jqXHR.status === 200) {
                $("#RepositoryBrowserForSelect .modal-body").html(data);

                $("#RepositoryBrowserForSelect").modal();

                $("#RepositoryBrowserForSelectSelected").off("click", function () { });
                $("#RepositoryBrowserForSelectSelected").on("click", function () {
                    _repositoryBrowserForSelectCallBack(DataprojektBootstrap.RepositoryTreeForSelectObject.jstree('get_selected'));
                });
            } else {
                DataprojektBootstrap.Notification(DataprojektBootstrap.NotificationType.Warning, DataprojektLocalizer.Tree["Repository browser was not successfully shown"]);
            }
        }).fail(function () {
            DataprojektBootstrap.Notification(DataprojektBootstrap.NotificationType.Danger, DataprojektLocalizer.Tree["Repository browser was not successfully shown"]);
        });
    }
};

// Methods
$(document).ready(function () {
    $('[data-toggle="popover-hover"]').popover({
        animation: true,
        html: true,
        trigger: 'hover',
        delay: {
            show: "500",
            hide: "250"
        }
    });

    $('div.invalid-feedback').each(function () {
        if (!$(this).hasClass("input-validator-checked")) {
            if ($(this).text().trim() != "") {
                $(this).addClass("d-block");
                $(this).parents('div.input-container').find(".input-validator").addClass('is-invalid');
            }

            $(this).addClass("input-validator-checked");
        }
    });

    $('input[type="checkbox"].table-check-all').on("click", function () {
        var checked = $(this).is(':checked');

        $(this).closest("table").find('input[type="checkbox"].table-check-me').prop("checked", checked);
    });
});